

import { appConfig } from '../../service/AppConfig.js';

import { ContractTaskPopup }     from './ContractTaskPopup.js';
import { ContractLinkPopup }     from './ContractLinkPopup.js';
import { FileUploadSelectPopup } from '../files/FileUploadSelectPopup.js';
import { NoteListWidget }        from '../notes/NoteListWidget.js';

import { ActivityLogTab } from '../masterdata/activity/ActivityLogTab.js';



export class ContractEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/contracts/')}}" class="fa fa-chevron-circle-left"></a>
				
				<span ez-if="contract.contractId > 0">
					<a href="javascript:void(0);" [onclick]="widget.deleteContract" class="fa fa-trash"></a>
				</span>
				
				<a href="javascript:void(0);" [onclick]="widget.saveContract" class="fa fa-save"></a>
			</div>
			<h1>{{!contract.contractId?'Nieuw contract':'Bewerk contract #'+contract.contractId}} <span class="title-contractName"></span></h1>
		</div>
		
		
		<form id="frmContracts" action="{{appUrl('/service/contracts/edit.do')}}">
		
		<ul class="nav nav-tabs" id="contractTabs" role="tablist">
			<li class="nav-item" role="presentation">
				<button class="nav-link active" id="base-tab" data-bs-toggle="tab" data-bs-target="#base" type="button" role="tab" aria-controls="base" aria-selected="true">Basisgegevens</button>
		    </li>
		    <li class="nav-item" role="presentation" ez-if="isNew == false">
		    	<button class="nav-link" id="notes-tab" data-bs-toggle="tab" data-bs-target="#notes" type="button" role="tab" aria-controls="notes" aria-selected="false">Notities</button>
		    </li>
			<li class="nav-item" role="presentation" ez-if="isNew == false">
		    	<button class="nav-link" id="tasks-tab" data-bs-toggle="tab" data-bs-target="#tasks" type="button" role="tab" aria-controls="tasks" aria-selected="false">Taken</button>
		    </li>
			<li class="nav-item" role="presentation" ez-if="isNew == false">
		    	<button class="nav-link" id="docs-tab" data-bs-toggle="tab" data-bs-target="#docs" type="button" role="tab" aria-controls="docs" aria-selected="false">Documenten</button>
		    </li>
			<li class="nav-item" role="presentation" ez-if="isNew == false">
		    	<button class="nav-link" id="related-tab" data-bs-toggle="tab" data-bs-target="#related" type="button" role="tab" aria-controls="related" aria-selected="false">Gerelateerd</button>
		    </li>
			<li class="nav-item" role="presentation" ez-if="showPermissions == true">
		    	<button class="nav-link" id="perms-tab" data-bs-toggle="tab" data-bs-target="#perms" type="button" role="tab" aria-controls="perms" aria-selected="false">Permissies</button>
		    </li>
		</ul>

		
		<div class="tab-content" id="contractTabsContent">

		<div class="tab-pane fade show active" id="base" role="tabpanel" aria-labelledby="base-tab">
			<input type="hidden" name="a" value="save" />

			<input type="hidden" name="contractId" value="{{contract.contractId}}" />

			<ez-select name="status" label="Status" [value]="contract.status">
				<option value="open">Open</option>
				<option value="negotiation">In onderhandeling</option>
				<option value="reviewal">Ter beoordeling</option>
				<option value="accepted">Geaccepteerd</option>
				<option value="active">Actief</option>
				<option value="expiring">Aflopend</option>
				<option value="terminated">Beeindigd</option>
			</ez-select>

			<ez-text name="name" label="Contractnaam" [value]="contract.name"></ez-text>
			
			<ez-text name="amountDescription" label="Contract waarde" [value]="contract.amountDescription"></ez-text>
			
			<ez-select name="contractTypeId" label="Contract type" [value]="contract.contractTypeId"></ez-select>
			
			<div class="customerId-container">
				<ez-customer name="customerId" 
							label="Relatie"
							[value]="contract.customerId"
							[valueText]="contract.customerName"></ez-customer>
			</div>

			<ez-date name="startDate" label="Start contract" [value]="contract.startDate"></ez-date>
			
			<div class="end-date-container">
				<ez-date name="endDate" label="Einde contract" [value]="contract.endDate"></ez-date>
				
				<span class="plus-min">
					<a href="javascript:void(0);" [onclick]="widget.prevEndDate" class="fa fa-minus"></a>
					<a href="javascript:void(0);" [onclick]="widget.nextEndDate" class="fa fa-plus"></a>
				</span>
				
				<div class="clear"></div>
			</div>
			
			<div class="time-notice-container">
				<ez-number name="timeNotice" label="Opzegtermijn" [value]="contract.timeNotice"></ez-number>
				<ez-select name="timeNoticeUnit" label="" [value]="contract.timeNoticeUnit">
					<option value="day">Dag</option>
					<option value="week">Week</option>
					<option value="month">Maand</option>
					<option value="year">Jaar</option>
				</ez-select>
			</div>
			
			<ez-string name="renewalDate" label="Verlengdatum"></ez-string>
			
			<div class="renew-period-container">
				<ez-number name="renewPeriod" label="Verlengperiode" [value]="contract.renewPeriod"></ez-number>
				<ez-select name="renewUnit" label="" [value]="contract.renewUnit">
					<option value="day">Dag</option>
					<option value="week">Week</option>
					<option value="month">Maand</option>
					<option value="year">Jaar</option>
				</ez-select>
			</div>
			
			<div style="display: flex; align-items: start;">
				<ez-checkbox name="autoRenew" label="Automatisch verlengen" [checked]="contract.autoRenew"></ez-checkbox>
				
				<span class="autoRenew-warning mouseover-message">
					<i class="fa-solid fa-triangle-exclamation"></i>
					<div class="mouseover-message-text">Contract Status staat niet op <b>Actief</b> en wordt daarom niet automatisch verlengd.</div>
				</span>
			</div>
			
			<ez-textarea name="note" label="Notitie" [value]="contract.note"></ez-textarea>

			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="contract.edited"></ez-datetime-text>

			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="contract.created"></ez-datetime-text>
		</div>
	
		<div class="tab-pane fade" id="notes" role="tabpanel" aria-labelledby="notes-tab">
			<div id="notes-container"></div>
		</div>
			
			
<div ez-if="isNew == false">
			<div class="tab-pane fade" id="tasks" role="tabpanel" aria-labelledby="tasks-tab">
				<div class="action-box">
					<span>
						<a class="btn-add-task" href="javascript:void(0)" [onclick]="widget.editTask">Taak toevoegen</a>
					</span>
				</div>
				
				<br/>
			
				<div ez-subtemplate="tpl-tasks">
				<table class="table tbl-contract-tasks">
					<thead>
						<tr>
							<th>Omschrijving</th>
							<th>Periode</th>
							<th>Termijn</th>
							<th>Alert</th>
							<th>Status</th>
						</tr>
					</thead>
					
					<tbody ez-for="contract.tasks" ez-item="t">
						<tr class="task-record pointer task-status-{{t.nextStatus}}" data-task-id="{{t.contractTaskId}}" [onclick]="widget.editTask">
							<td>{{t.description}}</td>
							<td>{{ _('noticeMoment.'+t.noticeMoment) }}</td>
							<td>
								<span ez-if="t.noticeMoment != 'on_date'">
								{{t.timeNotice}} {{ t.timeNotice == 1 ? _(t.timeNoticeUnit) : _(t.timeNoticeUnit+'s')}}
								</span>
							</td>
							<td>
								<span ez-if="t.status != 'done'">
									{{ format_date(t.nextAlertDate, {dmy: true}) }}
								</span>
								<span ez-if="t.warningMessage != null">
									<span class="mouseover-message">
										<i class="fa-solid fa-triangle-exclamation"></i>
										<div class="mouseover-message-text">{{t.warningMessage}}</div>
									</span>
								</span>
							</td>
							<td class="{{ t.nextStatus == 'inactive' ? 'inactive-alert' : '' }}">
								{{ _(t.nextStatus) }}
								
								<span ez-if="t.nextStatus == 'inactive'">
									<i class="fa-solid fa-triangle-exclamation warning-icon"></i>
								</span>
							</td>
						</tr>
					</tbody>
					
						<tr ez-if="contract.tasks.length == 0">
							<td colspan="9" class="no-results">
								Geen taken
							</td>
						</tr>

				
				</table>
				</div>
			</div>
			
			<div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs-tab">
				<div class="action-box">
					<span>
						<a class="btn-link-document" href="javascript:void(0)" [onclick]="widget.addFile">Koppel Bestanden</a>
					</span>
				</div>
				
				<br/>
				
				<div ez-subtemplate="ref-files">
					<table class="table">
						<thead>
							<tr>
								<th class="th-sort-cell"></th>
								<th>Bestandsnaam</th>
								<th>Ref.</th>
								<th style="width: 180px;">Aangemaakt op</th>
								
							</tr>
						</thead>
						<tbody ez-for="files" ez-item="f" class="tbody-documents">
							<tr db-file-id="{{f.dbFileId}}">
								<td class="sort-cell" style="width: 20px;"><i class="fa fa-bars sort-handle ui-sortable-handle" /></td>
								<td>
									{{f.originalFilename}}
								</td>
								<td>
									{{f.refDescription}}
								</td>
								<td>
									{{format_datetime(f.created)}}
								</td>
							</tr>
						</tbody>
						<tr ez-if="!files">
							<td colspan="3" class="no-results">
								Loading...
							</td>
						</tr>
						<tr ez-if="files && files.length == 0">
							<td colspan="4" class="no-results">
								Geen bestanden
							</td>
						</tr>
					</table>
				</div>
				
			</div>
			
			
			<div class="tab-pane fade" id="related" role="tabpanel" aria-labelledby="related-tab">
				<div class="action-box">
					<span>
						<a class="btn-link-contract" href="javascript:void(0)" [onclick]="widget.linkContracts">Koppel Contracten</a>
					</span>
				</div>
				
				<br/>
				
				<div ez-subtemplate="ref-contracts">
					<table class="table">
						<thead>
							<tr>
								<th>Relatie</th>
								<th>Contract</th>
								<th>Waarde</th>
								<th>Contract type</th>
								<th>Startdatum</th>
								<th>Einddatum</th>
								<th>Verlengdatum</th>
								<th>Status</th>
								<th></th>
							</tr>
						</thead>
						<tbody ez-for="refContracts" ez-item="c">
							<tr contract-id="{{c.contractId}}" [onclick]="widget.gotoContract_Click" class="pointer">
								<td>
									{{c.customerName ?? ''}}
								</td>
								<td>
									{{c.name}}
								</td>
								<td>
									{{c.amountDescription}}
								</td>
								<td>
									{{c.contractTypeName}}
								</td>
								<td>
									{{c.startDate ? format_date(c.startDate, {dmy: true}) : ''}}
								</td>
								<td>
									{{c.endDate ? format_date(c.endDate, {dmy: true}) : ''}}
								</td>
								<td>
									{{c.renewalDate ? format_date(c.renewalDate, {dmy: true}) : ''}}
								</td>
								<td>
									{{_('contract_status.'+c.status)}}
								</td>
							</tr>
						</tbody>
						<tr ez-if="refContracts == null">
							<td colspan="9" class="no-results">
								Loading...
							</td>
						</tr>
						<tr ez-if="refContracts != null && refContracts.length == 0">
							<td colspan="9" class="no-results">
								Geen contracten gekoppeld
							</td>
						</tr>
					</table>
				</div>
			
			</div>
		
			
</div> <!-- ez-if isNew == false .... -->
		
		
			<div class="tab-pane fade permissions-edit-container" id="perms" role="tabpanel" aria-labelledby="perms-tab">
				<div class="action-box">
					<span>
						<a class="btn-link-user-group" href="javascript:void(0);" [onclick]="widget.addPermissionRecord">Gebruiker/groep toevoegen</a>
					</span>
				</div>
				
				<br/>

				<table class="table">
					<thead>
						<tr>
							<th>Gebruiker</th>
							<th>Permissies</th>
							<th></th>
						</tr>
					</thead>
					
					<tbody id="tbody-permissions">
						
					</tbody>
					
				</table>
			</div>
			
		</div>
		
		</form>
	`;
	
	container = null;
	loading = false;
	
	loadTypesExecuted = false;
	contractTypes = null;
	
	refContracts = null;
	files = null;
	
	
	ezTpl = null;
	contract = {
		name: '',
		startDate: '',
		note: '',
		timeNoticeUnit: 'month',
		renewUnit: 'month'
	};
	
	isNew = true;
	writable = true;
	
	input_counter = 0;
	
	init(e) {
		this.container = e;
		
		// already moved away?
		if (routeSet('/contracts/edit/') == false) {
			return;
		}
		
		let id = getUrlParam('id');
		
		if (id) {
			this.isNew = false;
			this.loadContract( id );
		}
		else {
			this.loadDefaults();
		}
		
		
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setVar('contract', this.contract);
		this.ezTpl.setVar('files', []);
		this.ezTpl.setVar('refContracts', this.refContracts);
//		this.ezTpl.setVar('showPermissions', toolboxConfig.desktopMode ? false : true);
		this.ezTpl.setVar('showPermissions', true);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		this.setFiles(this.files);
		
		this.loadTypes();
		
		$('#frmContracts select[name=status], #cb_autoRenew').on('change', function() {
			this.handleAutorenewWarning();
		}.bind(this));
		this.handleAutorenewWarning();
		
//		$('tr.task-record').on('click', function(e) {
//			let tid = $(e.currentTarget).data('task-id');
//			if (tid)
//				this.editTask( tid );
//		}.bind(this));
		
		$('input[name=name]').on('keyup', function() {
			this.updateTitle();
		}.bind(this));
		
		$('input[name=name], input[name=amountDescription]').on('change', function() {
			this.value = trim(this.value);
		});
		
		$('ez-table-selector[name=customerId]').on('change', function() {
			this.updateCustomerInput();
		}.bind(this));
		this.updateCustomerInput();
		
		$('#frmContracts').find('[name=endDate], [name=timeNotice], [name=timeNoticeUnit]').on('change dp.change', function() {
			this.calcTimeNoticeDate();
		}.bind(this));
		this.calcTimeNoticeDate();
		
		if (appConfig.isAdmin() && this.contract.contractId) {
			let alt = new ActivityLogTab( 'itx.erp.contracts.model.Contract', this.contract.contractId );
			alt.show();
		}
					
		
		focusFirstField('#frmContracts');
	}
	
	readOnly() {
		$('.page-header .toolbox').find('a.fa-trash, a.fa-save').remove();
		$('.plus-min').remove();
		
		$('input, textarea').attr('readonly', 'readonly');
		$('input[type=checkbox], input[type=radio], select').attr('disabled', 'disabled');
		
		$('.btn-add-task').remove();
		$('.btn-link-document').remove();
		$('.btn-link-contract').remove();
		$('.btn-link-user-group').remove();
		
		$('ez-table-selector').attr('readonly', 'readonly');
	}
	
	setCustomerId( customerId ) {
		postUrl( '/service/customers.do', {
			a: 'view',
			customerId: customerId
		})
		.then( async function(e) {
			let json = await e.json();
			if (json && json.success) {
				json.customer.customerId;
				json.customer.customerName;
				
				// tws
				let tsw = document.querySelector('ez-customer[name="customerId"] .ez-table-container').tsw;
				tsw.setValueText( json.customer.customerId, json.customer.customerName );
			}
		}.bind(this));
		
	}
	
	saveContract() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		showLoadingForm( '#frmContracts' );
		
		
		let frm = serialize2object( '#frmContracts');
		
//		console.log( frm );
		postUrl( '/service/contracts/edit.do', frm)
		.then(async function(e) {
			let json = await e.json();
			this.loading = false;
			
			if (json.error) {
				// render errors
				formShowErrors( '#frmContracts', json );
			}
			else {
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				replaceRoute( '/contracts/edit/?id=' + json.contractId );
			}
			
		}.bind(this));
	}
	
	
	deleteContract() {
		
		showConfirmation('Verwijderen', 'Weet je zeker dat je dit contract wilt verwijderen?', function(e) {
			
			postUrl( '/service/contracts/edit.do', {
				a: 'delete',
				contractId: this.contract.contractId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + json.message);
					return;
				}
				
				gotoRoute( '/contracts/' );
			}.bind(this) );
			
		}.bind( this ));
		
	}
	
	
	updateTitle() {
		let n = $.trim( $('input[name=name]').val() );
		
		if (n != '')
			n = ' - ' + n;
		
		$('.title-contractName').text( n );
	}
	
	updateCustomerInput() {
		let frm = $('#frmContracts');
		let contractId = frm.find('input[name=contractId]').val();
		let customerId = frm.find('input[name=customerId]').val();
		
		
		
	}
		
	
	
	calcEndDate( plusMin ) {
		let sd = $('#frmContracts input[name=startDate]').val();
		let ed = $('#frmContracts input[name=endDate]').val();
		
		if (valid_date(sd) == false)
			return;
		
		let startDate = str2date( sd );
		sd = format_date( str2date(sd), {dmy: true});
		
		let endDate = null;
		if (valid_date(ed))
			endDate = str2date( ed );
		
		
		// determine last day no
		if (endDate) {
			
			// get next month
			let m = next_month( endDate, plusMin );
			
			$('#frmContracts input[name=endDate]').val( format_date(str2date(m), {dmy: true}) );
		}
		else {
			let nm = next_month( startDate, plusMin );
			$('#frmContracts input[name=endDate]').val( format_date(str2date(nm), {dmy: true}) );
		}
		
		this.calcTimeNoticeDate();
	}
	
	prevEndDate() {
		this.calcEndDate( -1 );
	}
	
	nextEndDate() {
		this.calcEndDate( 1 );
	}
	
	calcTimeNoticeDate() {
		let e = $('ez-string[name=renewalDate] span.value');
		
		let ed = $('#frmContracts input[name=endDate]').val();
		if (valid_date(ed) == false) {
			e.text('');
			return;
		}
		
		
		let timeNotice = parseInt( $('input[name=timeNotice]').val() );
		if (isNaN(timeNotice)) {
			timeNotice = 0;
//			e.text('');
//			return;
		}
		
		let timeNoticeUnit = $('select[name=timeNoticeUnit]').val();
		
		let d = null;
		if (timeNoticeUnit == 'day') {
			d = previous_day( ed, timeNotice );
		}
		else if (timeNoticeUnit == 'week') {
			d = previous_week( ed, timeNotice );
		}
		else if (timeNoticeUnit == 'month') {
			d = previous_month( ed, timeNotice );
		}
		else if (timeNoticeUnit == 'year') {
			d = previous_month( ed, timeNotice*12 );
		}

		if (d && valid_date(d)) {
			e.text( format_date( str2date(d), {dmy: true} ) );
		}
		else {
			e.text('');
		}
	}
	
	loadTypes() {
		if (this.loadTypesExecuted) {
			this.renderContractTypes()
			return;
		}
		
		this.loadTypesExecuted = true;
		
		
		postUrl( '/service/contracts/type.do'
		, {
			a: 'listTypes'
		})
		.then( async function(e) {
			let json = await e.json();
			this.contractTypes = json.contractTypes;
			
			this.renderContractTypes();
		}.bind(this) );
	}
	
	renderContractTypes() {
		let s = $('select[name=contractTypeId]');
		s.empty();
		
		for(let i in this.contractTypes) {
			let ct = this.contractTypes[i];
			
			let opt = $('<option />');
			opt.val( ct.contractTypeId );
			opt.text( ct.name );
			s.append( opt );
		}
		
		// select value..
		if (this.contract.contractTypeId)
			s.val( this.contract.contractTypeId );
		
	}
	
	
	loadContract(contractId) {
		let cur_url = window.location.toString();
		
		postUrl( '/service/contracts/edit.do', {
			a: 'view',
			contractId: contractId
		}).then(async function(e) {
			let json = await e.json();
			
			if ( cur_url != window.location.toString() ) {
				console.error('ContractEditWidget.loadContract, not rending, url changed');
				return;
			}
			
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.contract = json.contract;
			
//					for(let i in this.contract.tasks) {
//						let t = this.contract.tasks[i];
//					}
			
			this.writable = json.writable;
			
			this.loading = false;
			
			this.setFiles( this.contract.files );
			this.setRefContracts( this.contract.relatedContracts);
			
			
			this.render();
			
			if (json.writable == false) {
				this.readOnly();
			}
			
			this.updateTitle();
			
			this.loadNoteWidget();
			
			this.setPermissions( this.contract.permissions );
			
//				this.loadLinkedContracts();
//				this.linkContracts();
		}.bind(this));
	}
	
	
	loadDefaults() {
		
		postUrl('/service/contracts/edit.do', {
			a: 'defaultSettings'
		}).then( async (e) => {
			let json = await e.json();
			
			this.render();
			
			if (getUrlParam('ref_customerId')) {
				this.setCustomerId( getUrlParam('ref_customerId') );
			}
			
			if (json.permissions)
				this.setPermissions( json.permissions );
		});
		
	}
	
	
	
	
	handleAutorenewWarning() {
		$('.autoRenew-warning').hide();
		
		if ( $('#cb_autoRenew').prop('checked') == false )
			return;
		
		
		let status = $('#frmContracts select[name=status]').val();
		if (status == 'active') {
			$('.autoRenew-warning').hide();
		} else {
			$('.autoRenew-warning').show();
			
		}
		
	}
	
	
	loadTasks() {
		postUrl( '/service/contracts/edit.do', {
				a: 'view',
				contractId: this.contract.contractId
		}).then( async function(e) {
			let json = await e.json();
			this.contract.tasks = json.contract.tasks;
			
			// re-render subtemplate
			let eztpl = $('[ez-subtemplate="tpl-tasks"]').get(0).eztemplate;
			eztpl.setVar('contract', this.contract);
			eztpl.render();
		}.bind(this));

	}
	
	
	editTask( evt ) {
		let taskId = $(evt.currentTarget).attr('data-task-id');
		
		let p = new ContractTaskPopup();
		p.setContractId( this.contract.contractId );
		
		taskId = parseInt(taskId);
		if (isNaN(taskId) == false)
			p.loadTask( taskId );
		
		p.setCallbackSave(function (e) {
			this.loadTasks();
			
			showToastMessage( 'Wijzigingen opgeslagen' );
		}.bind(this));
		
		p.setCallbackClose(function (e) {
			this.loadTasks();
		}.bind(this));
		
		p.showPopup();
	}
	
	
	loadNoteWidget() {
		
		let w = new NoteListWidget();
		w.setRefObject('contract');
		w.setRefId( this.contract.contractId );
		w.setWritable( this.writable );
		
		w.init( '#notes-container' );
	}
	
	
	
	addFile() {
		let p = new FileUploadSelectPopup();
		p.setSelectedFiles( this.files );
		
		p.setCallbackLinkFile(function( fid ) {
			postUrl( '/service/contracts/edit.do', {
				a: 'linkFile',
				contractId: this.contract.contractId,
				dbFileId: fid
			});
			
			showToastMessage( 'Bestand gekoppeld' );
		}.bind(this));
		p.setCallbackUnlinkFile(function( fid ) {
			postUrl( '/service/contracts/edit.do', {
				a: 'unlinkFile',
				contractId: this.contract.contractId,
				dbFileId: fid
			});
			
			showToastMessage( 'Bestand ontkoppeld' );
		}.bind(this));
		
		p.setCallbackClose(function() {
			if ( p.isChanged ) {
				this.loadFiles();
			}
		}.bind(this));
		
		p.show();
	}
	
	loadFiles() {
		postUrl( '/service/contracts/edit.do', {
			a: 'listFiles',
			contractId: this.contract.contractId
		}).then( async function(e) {
			let json = await e.json();
			this.setFiles( json.files );
		}.bind(this));
	}
	
	saveFilesSort() {
		let ids = [];
		$('.tbody-documents > tr').each(function(index, node) {
			let id = node.getAttribute('db-file-id');
			ids.push( id );
		});
		
		postUrl( '/service/contracts/edit.do', {
			a: 'updateFileSort',
			contractId: this.contract.contractId,
			dbFileIds: ids.join(',')
		});
		
		showToastMessage( 'Volgorde opgeslagen' );
	}
	
	
	
	loadLinkedContracts() {
		postUrl( '/service/contracts/list.do', {
			relatedContractId: this.contract.contractId
		}).then( async function(e) {
			let json = await e.json();
			this.setRefContracts( json.contracts );
		}.bind(this));
		
	}
	
	setFiles( files ) {
		this.files = files;
		
		let t = $('[ez-subtemplate=ref-files]').get(0);
		if (!t)
			return;
		
		let eztpl = t.eztemplate;
		eztpl.setVar( 'files', this.files );
		eztpl.render();
		
		
		if (this.writable) {
			$('tbody.tbody-documents').sortable({
				handle: '.sort-handle',
				update: function() {
					this.saveFilesSort();
				}.bind(this)
			});
		}
		else {
			$(t).find('.th-sort-cell, .sort-cell').hide();
		}
		
		
		if (toolboxConfig.embeddedRequest) {
			let trs = $('.tbody-documents > tr');
			trs.addClass('pointer');
			trs.on('click', function(evt) {
				let t = $(evt.target);
				if ($(t).hasClass('sort-cell') || $(t).closest('.sort-cell').length > 0)
					return;
				
				let tr = evt.currentTarget;
				let dbFileId = tr.getAttribute('db-file-id');
				
				postUrl( '/service/files.do', {
					a: 'openFile',
					dbFileId: dbFileId
				});
				
			}.bind(this));
		}
		else {
			let trs = $('.tbody-documents > tr');
			trs.addClass('pointer');
			trs.on('click', function(evt) {
				let t = $(evt.target);
				if ($(t).hasClass('sort-cell') || $(t).closest('.sort-cell').length > 0)
					return;
				
				let tr = evt.currentTarget;
				let dbFileId = tr.getAttribute('db-file-id');
				
				window.location = appUrl( '/service/files.do?a=downloadFile&dbFileId=' + dbFileId );
			}.bind(this));
		}
	}
	
	setRefContracts( refContracts ) {
		this.refContracts = refContracts;
		
		let t = $('[ez-subtemplate=ref-contracts]').get(0);
		if (!t)
			return;
		
		let eztpl = t.eztemplate;
		eztpl.setVar( 'refContracts', this.refContracts );
		
		eztpl.render();
	}
	
	
	
	gotoContract_Click( evt, tr ) {
		let cid = tr.getAttribute('contract-id');
		
		
		for(let i in this.contract.relatedContracts) {
			let rc = this.contract.relatedContracts[i];
			
			if (rc.contractId == cid) {
				
				if (rc.allowView == false) {
					showAlert( _('Permission denied'), _('No permission to open contract'));
					return;
				}
				
				break;
			}
		}
		
		
		gotoRoute( '/contracts/edit/?id='+cid );
	}
	
	linkContracts() {
		let cl = new ContractLinkPopup( this.contract.contractId );
		cl.setCallbackClose(function() {
			console.log('jojo');
			this.loadLinkedContracts();
		}.bind(this));
		cl.show();
	}
	
	
	addPermissionRecord( ) {
		this.createPermissionRecord();
	}
	
	setPermissions( perms ) {
		
		for(let i=0; i < perms.length; i++) {
			this.createPermissionRecord( perms[i] );
		}
		
	}
	
	createPermissionRecord( opts ) {
		opts = opts ? opts : {};
		
		
		let no = ++this.input_counter;
		
		let tr = document.createElement('tr');
		
		let tduser        = document.createElement('td');
		
		let tdpermissions = document.createElement('td');
		tdpermissions.className = 'td-permissions';
		
		
		let inp_read = document.createElement('input');
		inp_read.type = 'radio';
		inp_read.name = 'perm_access_'+no;
		inp_read.value = 'read';
		inp_read.checked = true;
		if (this.writable == false)
			inp_read.setAttribute('disabled', 'disabled');
		
		let lbl_read = document.createElement('label');
		lbl_read.className = 'perm-read';
		lbl_read.append( inp_read );
		lbl_read.append( ' lezen ' );
		
		tdpermissions.append( lbl_read );
		
		
		
		let inp_write = document.createElement('input');
		inp_write.type = 'radio';
		inp_write.value = 'write';
		inp_write.name = 'perm_access_'+no;
		if (this.writable == false)
				inp_write.setAttribute('disabled', 'disabled');
		
		let lbl_write = document.createElement('label');
		lbl_write.className = 'perm-write';
		lbl_write.append(inp_write);
		lbl_write.append( ' schrijven ');
		tdpermissions.append( lbl_write );
		
		if (opts && opts.accessMethod == 'read') {
			inp_read.checked = true;
			inp_write.checked = false;
		}
		if (opts && opts.accessMethod == 'write') {
			inp_read.checked = false;
			inp_write.checked = true;
		}
		
		
		// del
		let tdactions     = document.createElement('td');
		tdactions.className = 'actions';
		
		if (this.writable) {
			let a_del = document.createElement('a');
			a_del.className = 'fa fa-trash';
			a_del.href = 'javascript:void(0);';
			a_del.onclick = function() {
				$(this).closest('tr').remove();
			};
			tdactions.append( a_del );
		}
		
		
		
		tr.append( tduser );
		tr.append( tdpermissions );
		tr.append( tdactions );
		
		let tbody_permissions = document.getElementById( 'tbody-permissions' );
		console.log('tbody_per', tbody_permissions);
		document.getElementById( 'tbody-permissions' ).append( tr );
		
		if (this.writable) {
			let d = document.createElement('div');
			d.className = 'ez-table-container';
			tduser.append(d);
			
			
			let eztbl = new EzTableSelector( d );
			eztbl.setName( 'perm_ug_'+no );
			
			if (opts && opts.refUserGroupId ) {
				eztbl.setValueText( opts.refUserGroupId, opts.textValue );
			}
			eztbl.setUrl( appUrl('/service/users.do?a=listUserGroups') );
			eztbl.init();
		}
		else {
			let span_username = document.createElement('span');
			span_username.innerText = opts.textValue;
			tduser.append( span_username );
		}
	}
	
	
}


